<?php
// public/employees.php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_login();

// Session for flash messages
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Handle Add/Edit/Delete
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // --- Add Employee ---
    if (isset($_POST['add_employee'])) {
        $sql = "INSERT INTO department (department, college_office)
                VALUES (?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $_POST['department'],
            $_POST['college_office'],
           
        ]);
        $emp_id = $pdo->lastInsertId();
        $_SESSION['success'] = "Office added successfully!";
        header("Location: department.php");
        exit;
    }
}

$empQuery = $pdo->query("SELECT * FROM department ORDER BY id ASC");
$employees = $empQuery->fetchAll(PDO::FETCH_ASSOC);

$title = "Department | JO & COS RMS";
include __DIR__ . '/../includes/header.php';
include __DIR__ . '/../includes/sidebar.php';
?>

<!-- Page Header -->
<section class="content-header">
  <div class="container-fluid">
    <h1>Department</h1>
  </div>
</section>

<!-- Flash Message -->
<?php if (!empty($_SESSION['success'])): ?>
<div class="alert alert-success alert-dismissible fade show mx-3" role="alert">
  <?= htmlspecialchars($_SESSION['success']) ?>
  <button type="button" class="close" data-dismiss="alert">&times;</button>
</div>
<?php unset($_SESSION['success']); endif; ?>

<!-- Page Content -->
<section class="content">
  <div class="card">
    <div class="card-header">
      <button class="btn btn-primary" data-toggle="modal" data-target="#addModal">
        <i class="fas fa-plus"></i> Add Department
      </button>
    </div>
    <div class="card-body table-responsive">
    <table id="employeesTable" class="table table-bordered table-striped nowrap" style="width:100%">
    <thead>
        <tr>
            <th>Department Name</th>
            <th>College/Office</th>
            
        </tr>
    </thead>
    <tbody>
        <?php foreach ($employees as $emp): ?>
            <tr>
                <td><?= htmlspecialchars($emp['department']) ?></td>
                <td><?= htmlspecialchars($emp['college_office']) ?></td>
                

       
          </tr>

        
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</section>

<!-- Add Employee Modal -->
<div class="modal fade" id="addModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form method="post" enctype="multipart/form-data">
        <div class="modal-header">
          <h5 class="modal-title">Add Department</h5>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <div class="form-row">
            <div class="form-group col-md-6"><label>Department Name</label><input type="text" name="department" class="form-control" required></div>
          <div class="form-group col-md-6">  <label>Office/College</label><input name="college_office" class="form-control" required> </div>
						
						
          <button type="submit" name="add_employee" class="btn btn-primary">Add</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>

<!-- DataTables -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap4.min.css"/>

<script>
$(function () {
  $('#employeesTable').DataTable({
    responsive: true,
    autoWidth: false
  });
});
</script>
